//Exp 3.1 Program Title:Quantization of grey scale image using 1,2,3 and 4 bits per pixels
///environment: Scilab 5.5.2
//Toolbox: Image Processing Design 8.3.1-1
//Toolbox: SIVP 0.5.3.2
//Tested on OS: Windows 7 Professional, 64 bit
//Reference books names : 1)Digital Image Processing book author :
// Rafael C.Gonzalez and Richard E.Woods,
//2)Digital Image Processing book author :S.Sudhir,
//3)Digital Image Processing book author :Dhanajay Theckedath
clc //to clear command window.
clear all //to disable previously defined variables.
xdel(winsid());///clear all the previous figures plots
SIVP_PATH = getSIVPpath(); //to locate a directory in which SIVP toolbox is installed
ii1=imread(SIVP_PATH + 'images/rose.bmp');//read second color image from diractory
ii=rgb2gray(ii1);//to convert an image into grayscale image.
t5=quag(ii,4);//quantization by using 4 bits i.e 16 gray level
t6=quag(ii,3);//quantization by using 3 bits i.e 8 gray level
t7=quag(ii,2);//quantization by using 2 bits i.e 4 gray level
t8=quag(ii,1);//quantization by using 1 bit i.e 2 gray level
figure(1);ShowImage(ii,'original gray image having size 256 x 384');title('original grey image','color','red','fontsize',5);//IPD tool box
figure(2);ShowImage(t5,'Quantized using 16 grey level');title('Quantized using 16 grey level','color','red','fontsize',5);//IPD tool box
figure(3);ShowImage(t6,'Quantized using 8 grey level');title('Quantized using 8 grey level','color','red','fontsize',5);//IPD tool box
figure(4);ShowImage(t7,'Quantized using 4 grey level');title('Quantized using 4 grey level','color','red','fontsize',5);//IPD tool box
figure(5);ShowImage(t8,'Quantized using 2 grey level');title('Quantized using 2 grey level','color','red','fontsize',5);//IPD tool box
